% Credit Scoring Toolbox.
% (c) Diego Pedregal. April 1998.
%
% Models:
%   BDA       Bayesian Discriminant Analysis Model Estimation.
%   LMDA      Linear Multivariable Discriminant Analysis.
%   LOGIT     LOGIT Model Estimation, by ML.
%   LPM       Linear Probability Model Estimation (OLS and GLS).
%   PROBIT    PROBIT Model Estimation, by ML.
%   SSPROBIT  Probit model with sample selection.
%
% Model output and model auxiliary functions:
%   ERRORTAB  Table with correct classification of models.
%   FITSTATS  Table with fitting statistics from model.
%   BIVNORM   Standard bivariate normal CDF.
%   SSFUN     Auxiliary function for the computation of the likelihood.
%
% Descriptive statistics with categorical data:
%   STATIST   Sample descriptive statistics.
%   MHIST     Multiple histograms with normal theoretical
%             and empirical distributions on background.
%   TABULAR   Percentiles (distribution) of a uni- or bivariate variable.
%             Data may be either numerical or categorical.
%   BISTATS   Descriptive statistics for variables
%             splitted according to categorical data.
%   BIBISTAT  Cross table between two categorical variables.
%   PERCENT   Percentiles (distribution) of a numerical variable.
%   PERPER    Percentiles (distribution) of a bivariate numerical variable.
%   PERTABLE  Percentiles (distribution) of a numerical vs
%             a categorical variable.
%
% General purpose auxiliary functions:
%   DENS      Empirical density function.
%   EXTRACT   Auxiliary function to extract a vector with
%             the different elements in x.
%   STRDIV    Creates a matrix string from a single string.
%   PRINTFM   Produces matrices in readable format.
%             different distributions.
%   COVNAN    Covariance matrix of vector variables (with nan's).
%   MINAN     Minimum of vector variables (with nan's).
%   MAXNAN    Maximum of vector variables (with nan's).
%   MEANAN    Mean of vector variables (with nan's or Inf's).
%   MEDIANAN  Median of vector variables (with nan's).
%   STDNAN    Standard deviation matrix of vector variables (with nan's).
%   SWAP      Swaps the values of variables x and y.
%   UDIST     1 - cumulative distribution function (cdf) for


