function [bOLS, covOLS, fitOLS, forOLS, bGLS, covGLS, fitGLS, forGLS]= ...
                                         lpm(y, X, Xfor, output, Xlabel, GLS)
%LPM   Linear Probability Model Estimation, by GLS.
%      [bOLS, covOLS, fitOLS, forOLS, bGLS, covGLS, fitGLS, forGLS]= ...
%                             lpm(y, X, Xfor, output, Xlabel, GLS)
%
% bOLS: Estimated OLS beta parameters.
% covOLS: Covariance of beta OLS estimated parameters.
% fitOLS: Fitted values by OLS.
% forOLS: Forecast values by OLS.
% bGLS: Estimated GLS beta parameters.
% covGLS: Covariance of beta GLS estimated parameters.
% fitGLS: Fitted values by GLS.
% forGLS: Forecast values by GLS.
%
% y: Binary output variable.
% X: Input variables.
% Xfor: Input values for new elements to forecast.
% output: Tabular and graphical output on/off.
% Xlabel: Input variable names.
% GLS: GLS estimation on/off (1/0).

%	(c) Diego Pedregal. Jan - 1998
