function [bML, covML, fitML, forML, deriv, Stats]= ...
                                probit(y, X, Xfor, opts, b0, output, Xlabel)
% PROBIT PROBIT Model Estimation, by ML.
%        [bML, covML, fitML, forML]= ...
%              probit(y, X, Xfor, opts, b0, output, Xlabel)
%
% bML: Estimated Maximum Likelihood beta parameters.
% covML: Covariance of beta estimated parameters.
% fitML: Fitted values.
% forML: forecast values.
%
% y: Binary output variable.
% X: Input variables.
% Xfor: Input variables for new elements to forecast.
% opts: Options to control non-linear estimation
%       opts(1): output on/off (Default: 1).
%       opts(2): Termination tolerance for parameters.(Default: 1e-4).
%	      opts(3)-Termination tolerance on F.(Default: 1e-4).
% b0: Initial conditions for estimation.
% output: Tabular and graphical output on/off.
% Xlabel: Input variable names.

%	(c) Diego Pedregal. Jan - 1998
