function [B1, B2, covML, fit1, fit2, for1, for2, deriv, Stats]= ...
                ssprobit(y1, X1, y2, X2, X1for, X2for, cens, opts, b0, const, output, Xlabel)
%SSPROBIT   Probit model with sample selection.
%           [B1, B2, covML, fit1, fit2, for1, for2]= ...
%               ssprobit(y1, X1, y2, X2, X1for, X2for, cens, opts, b0, const, output, Xlabel)
%
% B1: Estimated Maximum Likelihood beta parameters first equation.
% B2: Estimated Maximum Likelihood beta parameters second equation.
% covML: Covariance of beta estimated parameters.
% fit1: Fitted values first equation.
% fit2: Fitted values second equation.
% for1: Forecast values first equation.
% for2: Forecast values second equation.
%
% y1: Binary endogenous variable for selection (first) equation.
% X1: Exogenous variables for selection (first) equation.
% y2: Binary endogenous variable for second equation.
% X2: Exogenous variables for second equation.
% X1for: Input variables for new elements to forecast first equation.
% X2for: Input variables for new elements to forecast second equation.
% cens: 1 for censored or 2 for truncated data.
% opts: Options to control non-linear estimation
%       opts(1): output on/off (Default: 1).
%       opts(2): Termination tolerance for parameters.(Default: 1e-4).
%       opts(3)-Termination tolerance on F.(Default: 1e-4).
% b0: initial conditions for parameters.
% const: Rho constraint estimation.
% output: Tabular and graphical output on/off.
% Xlabel: Label for table outputs.
%
%  CENS: Values 1-censored by ML
%               2-Truncated by ML (default)
%              -1-Heckman procedure

%	(c) Diego Pedregal. April - 1998
